<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package BONBON
 * @since BONBON 1.0
 */

							do_action( 'bonbon_action_page_content_end_text' );
							
							// Widgets area below the content
							bonbon_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'bonbon_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'bonbon_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'bonbon_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'bonbon_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$bonbon_body_style = bonbon_get_theme_option( 'body_style' );
					$bonbon_widgets_name = bonbon_get_theme_option( 'widgets_below_page' );
					$bonbon_show_widgets = ! bonbon_is_off( $bonbon_widgets_name ) && is_active_sidebar( $bonbon_widgets_name );
					$bonbon_show_related = bonbon_is_single() && bonbon_get_theme_option( 'related_position' ) == 'below_page';
					if ( $bonbon_show_widgets || $bonbon_show_related ) {
						if ( 'fullscreen' != $bonbon_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $bonbon_show_related ) {
							do_action( 'bonbon_action_related_posts' );
						}

						// Widgets area below page content
						if ( $bonbon_show_widgets ) {
							bonbon_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $bonbon_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'bonbon_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'bonbon_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! bonbon_is_singular( 'post' ) && ! bonbon_is_singular( 'attachment' ) ) || ! in_array ( bonbon_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="bonbon_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'bonbon_action_before_footer' );

				// Footer
				$bonbon_footer_type = bonbon_get_theme_option( 'footer_type' );
				if ( 'custom' == $bonbon_footer_type && ! bonbon_is_layouts_available() ) {
					$bonbon_footer_type = 'default';
				}
				get_template_part( apply_filters( 'bonbon_filter_get_template_part', "templates/footer-" . sanitize_file_name( $bonbon_footer_type ) ) );

				do_action( 'bonbon_action_after_footer' );

			}
			?>

			<?php do_action( 'bonbon_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'bonbon_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'bonbon_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>