<div class="front_page_section front_page_section_googlemap<?php
	$bonbon_scheme = bonbon_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! empty( $bonbon_scheme ) && ! bonbon_is_inherit( $bonbon_scheme ) ) {
		echo ' scheme_' . esc_attr( $bonbon_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( bonbon_get_theme_option( 'front_page_googlemap_paddings' ) );
	if ( bonbon_get_theme_option( 'front_page_googlemap_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$bonbon_css      = '';
		$bonbon_bg_image = bonbon_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $bonbon_bg_image ) ) {
			$bonbon_css .= 'background-image: url(' . esc_url( bonbon_get_attachment_url( $bonbon_bg_image ) ) . ');';
		}
		if ( ! empty( $bonbon_css ) ) {
			echo ' style="' . esc_attr( $bonbon_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$bonbon_anchor_icon = bonbon_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$bonbon_anchor_text = bonbon_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $bonbon_anchor_icon ) || ! empty( $bonbon_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $bonbon_anchor_icon ) ? ' icon="' . esc_attr( $bonbon_anchor_icon ) . '"' : '' )
									. ( ! empty( $bonbon_anchor_text ) ? ' title="' . esc_attr( $bonbon_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
		<?php
		$bonbon_layout = bonbon_get_theme_option( 'front_page_googlemap_layout' );
		echo ' front_page_section_layout_' . esc_attr( $bonbon_layout );
		if ( bonbon_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
			echo ' bonbon-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
		"
			<?php
			$bonbon_css      = '';
			$bonbon_bg_mask  = bonbon_get_theme_option( 'front_page_googlemap_bg_mask' );
			$bonbon_bg_color_type = bonbon_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $bonbon_bg_color_type ) {
				$bonbon_bg_color = bonbon_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $bonbon_bg_color_type ) {
				$bonbon_bg_color = bonbon_get_scheme_color( 'bg_color', $bonbon_scheme );
			} else {
				$bonbon_bg_color = '';
			}
			if ( ! empty( $bonbon_bg_color ) && $bonbon_bg_mask > 0 ) {
				$bonbon_css .= 'background-color: ' . esc_attr(
					1 == $bonbon_bg_mask ? $bonbon_bg_color : bonbon_hex2rgba( $bonbon_bg_color, $bonbon_bg_mask )
				) . ';';
			}
			if ( ! empty( $bonbon_css ) ) {
				echo ' style="' . esc_attr( $bonbon_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
		if ( 'fullwidth' != $bonbon_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$bonbon_caption     = bonbon_get_theme_option( 'front_page_googlemap_caption' );
			$bonbon_description = bonbon_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $bonbon_caption ) || ! empty( $bonbon_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $bonbon_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $bonbon_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $bonbon_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $bonbon_caption, 'bonbon_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $bonbon_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $bonbon_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $bonbon_description ), 'bonbon_kses_content' );
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $bonbon_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$bonbon_content = bonbon_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $bonbon_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $bonbon_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $bonbon_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $bonbon_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $bonbon_content, 'bonbon_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $bonbon_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $bonbon_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
				<?php
				if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
					dynamic_sidebar( 'front_page_googlemap_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! bonbon_exists_trx_addons() ) {
						bonbon_customizer_need_trx_addons_message();
					} else {
						bonbon_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
					}
				}
				?>
			</div>
			<?php

			if ( 'columns' == $bonbon_layout && ( ! empty( $bonbon_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
