<?php
$bonbon_woocommerce_sc = bonbon_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $bonbon_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$bonbon_scheme = bonbon_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $bonbon_scheme ) && ! bonbon_is_inherit( $bonbon_scheme ) ) {
			echo ' scheme_' . esc_attr( $bonbon_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( bonbon_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( bonbon_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$bonbon_css      = '';
			$bonbon_bg_image = bonbon_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $bonbon_bg_image ) ) {
				$bonbon_css .= 'background-image: url(' . esc_url( bonbon_get_attachment_url( $bonbon_bg_image ) ) . ');';
			}
			if ( ! empty( $bonbon_css ) ) {
				echo ' style="' . esc_attr( $bonbon_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$bonbon_anchor_icon = bonbon_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$bonbon_anchor_text = bonbon_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $bonbon_anchor_icon ) || ! empty( $bonbon_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $bonbon_anchor_icon ) ? ' icon="' . esc_attr( $bonbon_anchor_icon ) . '"' : '' )
											. ( ! empty( $bonbon_anchor_text ) ? ' title="' . esc_attr( $bonbon_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( bonbon_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' bonbon-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$bonbon_css      = '';
				$bonbon_bg_mask  = bonbon_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$bonbon_bg_color_type = bonbon_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $bonbon_bg_color_type ) {
					$bonbon_bg_color = bonbon_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $bonbon_bg_color_type ) {
					$bonbon_bg_color = bonbon_get_scheme_color( 'bg_color', $bonbon_scheme );
				} else {
					$bonbon_bg_color = '';
				}
				if ( ! empty( $bonbon_bg_color ) && $bonbon_bg_mask > 0 ) {
					$bonbon_css .= 'background-color: ' . esc_attr(
						1 == $bonbon_bg_mask ? $bonbon_bg_color : bonbon_hex2rgba( $bonbon_bg_color, $bonbon_bg_mask )
					) . ';';
				}
				if ( ! empty( $bonbon_css ) ) {
					echo ' style="' . esc_attr( $bonbon_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$bonbon_caption     = bonbon_get_theme_option( 'front_page_woocommerce_caption' );
				$bonbon_description = bonbon_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $bonbon_caption ) || ! empty( $bonbon_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $bonbon_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $bonbon_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $bonbon_caption, 'bonbon_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $bonbon_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $bonbon_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $bonbon_description ), 'bonbon_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $bonbon_woocommerce_sc ) {
						$bonbon_woocommerce_sc_ids      = bonbon_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$bonbon_woocommerce_sc_per_page = count( explode( ',', $bonbon_woocommerce_sc_ids ) );
					} else {
						$bonbon_woocommerce_sc_per_page = max( 1, (int) bonbon_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$bonbon_woocommerce_sc_columns = max( 1, min( $bonbon_woocommerce_sc_per_page, (int) bonbon_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$bonbon_woocommerce_sc}"
										. ( 'products' == $bonbon_woocommerce_sc
												? ' ids="' . esc_attr( $bonbon_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $bonbon_woocommerce_sc
												? ' category="' . esc_attr( bonbon_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $bonbon_woocommerce_sc
												? ' orderby="' . esc_attr( bonbon_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( bonbon_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $bonbon_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $bonbon_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
