<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package BONBON
 * @since BONBON 1.0
 */

$bonbon_template = apply_filters( 'bonbon_filter_get_template_part', bonbon_blog_archive_get_template() );

if ( ! empty( $bonbon_template ) && 'index' != $bonbon_template ) {

	get_template_part( $bonbon_template );

} else {

	bonbon_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$bonbon_stickies   = is_home()
								|| ( in_array( bonbon_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) bonbon_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$bonbon_post_type  = bonbon_get_theme_option( 'post_type' );
		$bonbon_args       = array(
								'blog_style'     => bonbon_get_theme_option( 'blog_style' ),
								'post_type'      => $bonbon_post_type,
								'taxonomy'       => bonbon_get_post_type_taxonomy( $bonbon_post_type ),
								'parent_cat'     => bonbon_get_theme_option( 'parent_cat' ),
								'posts_per_page' => bonbon_get_theme_option( 'posts_per_page' ),
								'sticky'         => bonbon_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $bonbon_stickies )
															&& count( $bonbon_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		bonbon_blog_archive_start();

		do_action( 'bonbon_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'bonbon_action_before_page_author' );
			get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'bonbon_action_after_page_author' );
		}

		if ( bonbon_get_theme_option( 'show_filters' ) ) {
			do_action( 'bonbon_action_before_page_filters' );
			bonbon_show_filters( $bonbon_args );
			do_action( 'bonbon_action_after_page_filters' );
		} else {
			do_action( 'bonbon_action_before_page_posts' );
			bonbon_show_posts( array_merge( $bonbon_args, array( 'cat' => $bonbon_args['parent_cat'] ) ) );
			do_action( 'bonbon_action_after_page_posts' );
		}

		do_action( 'bonbon_action_blog_archive_end' );

		bonbon_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
