<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'bonbon_mailchimp_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'bonbon_mailchimp_theme_setup9', 9 );
	function bonbon_mailchimp_theme_setup9() {
		if ( bonbon_exists_mailchimp() ) {
			add_action( 'wp_enqueue_scripts', 'bonbon_mailchimp_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_mailchimp', 'bonbon_mailchimp_frontend_scripts', 10, 1 );
			add_filter( 'bonbon_filter_merge_styles', 'bonbon_mailchimp_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'bonbon_filter_tgmpa_required_plugins', 'bonbon_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'bonbon_mailchimp_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('bonbon_filter_tgmpa_required_plugins',	'bonbon_mailchimp_tgmpa_required_plugins');
	function bonbon_mailchimp_tgmpa_required_plugins( $list = array() ) {
		if ( bonbon_storage_isset( 'required_plugins', 'mailchimp-for-wp' ) && bonbon_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'install' ) !== false ) {
			$list[] = array(
				'name'     => bonbon_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'title' ),
				'slug'     => 'mailchimp-for-wp',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'bonbon_exists_mailchimp' ) ) {
	function bonbon_exists_mailchimp() {
		return function_exists( '__mc4wp_load_plugin' ) || defined( 'MC4WP_VERSION' );
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue styles for frontend
if ( ! function_exists( 'bonbon_mailchimp_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'bonbon_mailchimp_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_mailchimp', 'bonbon_mailchimp_frontend_scripts', 10, 1 );
	function bonbon_mailchimp_frontend_scripts( $force = false ) {
		bonbon_enqueue_optimized( 'mailchimp', $force, array(
			'css' => array(
				'bonbon-mailchimp-for-wp' => array( 'src' => 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' ),
			)
		) );
	}
}

// Merge custom styles
if ( ! function_exists( 'bonbon_mailchimp_merge_styles' ) ) {
	//Handler of the add_filter( 'bonbon_filter_merge_styles', 'bonbon_mailchimp_merge_styles');
	function bonbon_mailchimp_merge_styles( $list ) {
		$list[ 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( bonbon_exists_mailchimp() ) {
	$bonbon_fdir = bonbon_get_file_dir( 'plugins/mailchimp-for-wp/mailchimp-for-wp-style.php' );
	if ( ! empty( $bonbon_fdir ) ) {
		require_once $bonbon_fdir;
	}
}

