<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package BONBON
 * @since BONBON 1.0
 */

if ( bonbon_sidebar_present() ) {
	
	$bonbon_sidebar_type = bonbon_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $bonbon_sidebar_type && ! bonbon_is_layouts_available() ) {
		$bonbon_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $bonbon_sidebar_type ) {
		// Default sidebar with widgets
		$bonbon_sidebar_name = bonbon_get_theme_option( 'sidebar_widgets' );
		bonbon_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $bonbon_sidebar_name ) ) {
			dynamic_sidebar( $bonbon_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$bonbon_sidebar_id = bonbon_get_custom_sidebar_id();
		do_action( 'bonbon_action_show_layout', $bonbon_sidebar_id );
	}
	$bonbon_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $bonbon_out ) ) {
		$bonbon_sidebar_position    = bonbon_get_theme_option( 'sidebar_position' );
		$bonbon_sidebar_position_ss = bonbon_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $bonbon_sidebar_position );
			echo ' sidebar_' . esc_attr( $bonbon_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $bonbon_sidebar_type );

			$bonbon_sidebar_scheme = apply_filters( 'bonbon_filter_sidebar_scheme', bonbon_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $bonbon_sidebar_scheme ) && ! bonbon_is_inherit( $bonbon_sidebar_scheme ) && 'custom' != $bonbon_sidebar_type ) {
				echo ' scheme_' . esc_attr( $bonbon_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="bonbon_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'bonbon_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $bonbon_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$bonbon_title = apply_filters( 'bonbon_filter_sidebar_control_title', 'float' == $bonbon_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'bonbon' ) : '' );
				$bonbon_text  = apply_filters( 'bonbon_filter_sidebar_control_text', 'above' == $bonbon_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'bonbon' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $bonbon_title ); ?>"><?php echo esc_html( $bonbon_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'bonbon_action_before_sidebar', 'sidebar' );
				bonbon_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $bonbon_out ) );
				do_action( 'bonbon_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'bonbon_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
