<?php
/**
 * The template to display single post
 *
 * @package BONBON
 * @since BONBON 1.0
 */

// Full post loading
$full_post_loading          = bonbon_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = bonbon_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = bonbon_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$bonbon_related_position   = bonbon_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$bonbon_posts_navigation   = bonbon_get_theme_option( 'posts_navigation' );
$bonbon_prev_post          = false;
$bonbon_prev_post_same_cat = bonbon_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( bonbon_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	bonbon_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'bonbon_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $bonbon_posts_navigation ) {
		$bonbon_prev_post = get_previous_post( $bonbon_prev_post_same_cat );  // Get post from same category
		if ( ! $bonbon_prev_post && $bonbon_prev_post_same_cat ) {
			$bonbon_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $bonbon_prev_post ) {
			$bonbon_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $bonbon_prev_post ) ) {
		bonbon_sc_layouts_showed( 'featured', false );
		bonbon_sc_layouts_showed( 'title', false );
		bonbon_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $bonbon_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/content', 'single-' . bonbon_get_theme_option( 'single_style' ) ), 'single-' . bonbon_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $bonbon_related_position, 'inside' ) === 0 ) {
		$bonbon_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'bonbon_action_related_posts' );
		$bonbon_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $bonbon_related_content ) ) {
			$bonbon_related_position_inside = max( 0, min( 9, bonbon_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $bonbon_related_position_inside ) {
				$bonbon_related_position_inside = mt_rand( 1, 9 );
			}

			$bonbon_p_number         = 0;
			$bonbon_related_inserted = false;
			$bonbon_in_block         = false;
			$bonbon_content_start    = strpos( $bonbon_content, '<div class="post_content' );
			$bonbon_content_end      = strrpos( $bonbon_content, '</div>' );

			for ( $i = max( 0, $bonbon_content_start ); $i < min( strlen( $bonbon_content ) - 3, $bonbon_content_end ); $i++ ) {
				if ( $bonbon_content[ $i ] != '<' ) {
					continue;
				}
				if ( $bonbon_in_block ) {
					if ( strtolower( substr( $bonbon_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$bonbon_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $bonbon_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $bonbon_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$bonbon_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $bonbon_content[ $i + 1 ] && in_array( $bonbon_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$bonbon_p_number++;
					if ( $bonbon_related_position_inside == $bonbon_p_number ) {
						$bonbon_related_inserted = true;
						$bonbon_content = ( $i > 0 ? substr( $bonbon_content, 0, $i ) : '' )
											. $bonbon_related_content
											. substr( $bonbon_content, $i );
					}
				}
			}
			if ( ! $bonbon_related_inserted ) {
				if ( $bonbon_content_end > 0 ) {
					$bonbon_content = substr( $bonbon_content, 0, $bonbon_content_end ) . $bonbon_related_content . substr( $bonbon_content, $bonbon_content_end );
				} else {
					$bonbon_content .= $bonbon_related_content;
				}
			}
		}

		bonbon_show_layout( $bonbon_content );
	}

	// Comments
	do_action( 'bonbon_action_before_comments' );
	comments_template();
	do_action( 'bonbon_action_after_comments' );

	// Related posts
	if ( 'below_content' == $bonbon_related_position
		&& ( 'scroll' != $bonbon_posts_navigation || bonbon_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || bonbon_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'bonbon_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $bonbon_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $bonbon_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $bonbon_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $bonbon_prev_post ) ); ?>"
			<?php do_action( 'bonbon_action_nav_links_single_scroll_data', $bonbon_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
