<?php
/**
 * Required plugins
 *
 * @package BONBON
 * @since BONBON 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$bonbon_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'bonbon' ),
	'page_builders' => esc_html__( 'Page Builders', 'bonbon' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'bonbon' ),
	'socials'       => esc_html__( 'Socials and Communities', 'bonbon' ),
	'events'        => esc_html__( 'Events and Appointments', 'bonbon' ),
	'content'       => esc_html__( 'Content', 'bonbon' ),
	'other'         => esc_html__( 'Other', 'bonbon' ),
);
$bonbon_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'bonbon' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'bonbon' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $bonbon_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'bonbon' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'bonbon' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $bonbon_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'bonbon' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'bonbon' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $bonbon_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'bonbon' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'bonbon' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $bonbon_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'bonbon' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'bonbon' ),
		'required'    => false,
		'logo'        => 'woocommerce.png',
		'group'       => $bonbon_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'bonbon' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'bonbon' ),
		'required'    => false,
		'logo'        => 'elegro-payment.png',
		'group'       => $bonbon_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'bonbon' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'bonbon' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $bonbon_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'bonbon' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'bonbon' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $bonbon_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $bonbon_theme_required_plugins_groups['events'],
	),
	'quickcal'                     => array(
		'title'       => esc_html__( 'QuickCal', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'quickcal.png',
		'group'       => $bonbon_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $bonbon_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'bonbon' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'bonbon' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $bonbon_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => bonbon_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $bonbon_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'logo'        => bonbon_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $bonbon_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => bonbon_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $bonbon_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'logo'        => bonbon_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $bonbon_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => bonbon_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $bonbon_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => bonbon_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $bonbon_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $bonbon_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'bonbon' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'revslider.png',
		'group'       => $bonbon_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'bonbon' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'bonbon' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $bonbon_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'bonbon' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'bonbon' ),
		'required'    => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $bonbon_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'bonbon' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'bonbon' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $bonbon_theme_required_plugins_groups['other'],
	),
);

if ( BONBON_THEME_FREE ) {
	unset( $bonbon_theme_required_plugins['js_composer'] );
	unset( $bonbon_theme_required_plugins['booked'] );
	unset( $bonbon_theme_required_plugins['quickcal'] );
	unset( $bonbon_theme_required_plugins['the-events-calendar'] );
	unset( $bonbon_theme_required_plugins['calculated-fields-form'] );
	unset( $bonbon_theme_required_plugins['essential-grid'] );
	unset( $bonbon_theme_required_plugins['revslider'] );
	unset( $bonbon_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $bonbon_theme_required_plugins['trx_updater'] );
	unset( $bonbon_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
bonbon_storage_set( 'required_plugins', $bonbon_theme_required_plugins );
