<?php
/**
 * The template to display Admin notices
 *
 * @package BONBON
 * @since BONBON 1.0.1
 */

$bonbon_theme_slug = get_option( 'template' );
$bonbon_theme_obj  = wp_get_theme( $bonbon_theme_slug );
?>
<div class="bonbon_admin_notice bonbon_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$bonbon_theme_img = bonbon_get_file_url( 'screenshot.jpg' );
	if ( '' != $bonbon_theme_img ) {
		?>
		<div class="bonbon_notice_image"><img src="<?php echo esc_url( $bonbon_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'bonbon' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="bonbon_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'bonbon' ),
				$bonbon_theme_obj->get( 'Name' ) . ( BONBON_THEME_FREE ? ' ' . __( 'Free', 'bonbon' ) : '' ),
				$bonbon_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="bonbon_notice_text">
		<p class="bonbon_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $bonbon_theme_obj->description ) );
			?>
		</p>
		<p class="bonbon_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'bonbon' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="bonbon_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=bonbon_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'bonbon' );
			?>
		</a>
	</div>
</div>
