<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package BONBON
 * @since BONBON 1.0
 */

$bonbon_template_args = get_query_var( 'bonbon_template_args' );

if ( is_array( $bonbon_template_args ) ) {
	$bonbon_columns    = empty( $bonbon_template_args['columns'] ) ? 2 : max( 1, $bonbon_template_args['columns'] );
	$bonbon_blog_style = array( $bonbon_template_args['type'], $bonbon_columns );
    $bonbon_columns_class = bonbon_get_column_class( 1, $bonbon_columns, ! empty( $bonbon_template_args['columns_tablet']) ? $bonbon_template_args['columns_tablet'] : '', ! empty($bonbon_template_args['columns_mobile']) ? $bonbon_template_args['columns_mobile'] : '' );
} else {
	$bonbon_template_args = array();
	$bonbon_blog_style = explode( '_', bonbon_get_theme_option( 'blog_style' ) );
	$bonbon_columns    = empty( $bonbon_blog_style[1] ) ? 2 : max( 1, $bonbon_blog_style[1] );
    $bonbon_columns_class = bonbon_get_column_class( 1, $bonbon_columns );
}
$bonbon_expanded   = ! bonbon_sidebar_present() && bonbon_get_theme_option( 'expand_content' ) == 'expand';

$bonbon_post_format = get_post_format();
$bonbon_post_format = empty( $bonbon_post_format ) ? 'standard' : str_replace( 'post-format-', '', $bonbon_post_format );

?><div class="<?php
	if ( ! empty( $bonbon_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( bonbon_is_blog_style_use_masonry( $bonbon_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $bonbon_columns ) : esc_attr( $bonbon_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $bonbon_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $bonbon_columns )
				. ' post_layout_' . esc_attr( $bonbon_blog_style[0] )
				. ' post_layout_' . esc_attr( $bonbon_blog_style[0] ) . '_' . esc_attr( $bonbon_columns )
	);
	bonbon_add_blog_animation( $bonbon_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$bonbon_hover      = ! empty( $bonbon_template_args['hover'] ) && ! bonbon_is_inherit( $bonbon_template_args['hover'] )
							? $bonbon_template_args['hover']
							: bonbon_get_theme_option( 'image_hover' );

	$bonbon_components = ! empty( $bonbon_template_args['meta_parts'] )
							? ( is_array( $bonbon_template_args['meta_parts'] )
								? $bonbon_template_args['meta_parts']
								: explode( ',', $bonbon_template_args['meta_parts'] )
								)
							: bonbon_array_get_keys_by_value( bonbon_get_theme_option( 'meta_parts' ) );

	bonbon_show_post_featured( apply_filters( 'bonbon_filter_args_featured',
		array(
			'thumb_size' => ! empty( $bonbon_template_args['thumb_size'] )
				? $bonbon_template_args['thumb_size']
				: bonbon_get_thumb_size(
				'classic' == $bonbon_blog_style[0]
						? ( strpos( bonbon_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $bonbon_columns > 2 ? 'big' : 'huge' )
								: ( $bonbon_columns > 2
									? ( $bonbon_expanded ? 'square' : 'square' )
									: ($bonbon_columns > 1 ? 'square' : ( $bonbon_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( bonbon_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $bonbon_columns > 2 ? 'masonry-big' : 'full' )
								: ($bonbon_columns === 1 ? ( $bonbon_expanded ? 'huge' : 'big' ) : ( $bonbon_columns <= 2 && $bonbon_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $bonbon_hover,
			'meta_parts' => $bonbon_components,
			'no_links'   => ! empty( $bonbon_template_args['no_links'] ),
        ),
        'content-classic',
        $bonbon_template_args
    ) );

	// Title and post meta
	$bonbon_show_title = get_the_title() != '';
	$bonbon_show_meta  = count( $bonbon_components ) > 0 && ! in_array( $bonbon_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $bonbon_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'bonbon_filter_show_blog_meta', $bonbon_show_meta, $bonbon_components, 'classic' ) ) {
				if ( count( $bonbon_components ) > 0 ) {
					do_action( 'bonbon_action_before_post_meta' );
					bonbon_show_post_meta(
						apply_filters(
							'bonbon_filter_post_meta_args', array(
							'components' => join( ',', $bonbon_components ),
							'seo'        => false,
							'echo'       => true,
						), $bonbon_blog_style[0], $bonbon_columns
						)
					);
					do_action( 'bonbon_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'bonbon_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'bonbon_action_before_post_title' );
				if ( empty( $bonbon_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'bonbon_action_after_post_title' );
			}

			if( !in_array( $bonbon_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'bonbon_filter_show_blog_readmore', ! $bonbon_show_title || ! empty( $bonbon_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $bonbon_template_args['no_links'] ) ) {
						do_action( 'bonbon_action_before_post_readmore' );
						bonbon_show_post_more_link( $bonbon_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'bonbon_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $bonbon_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('bonbon_filter_show_blog_excerpt', empty($bonbon_template_args['hide_excerpt']) && bonbon_get_theme_option('excerpt_length') > 0, 'classic')) {
			bonbon_show_post_content($bonbon_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $bonbon_template_args['more_button'] )) {
			if ( empty( $bonbon_template_args['no_links'] ) ) {
				do_action( 'bonbon_action_before_post_readmore' );
				bonbon_show_post_more_link( $bonbon_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'bonbon_action_after_post_readmore' );
			}
		}
		$bonbon_content = ob_get_contents();
		ob_end_clean();
		bonbon_show_layout($bonbon_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
