<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package BONBON
 * @since BONBON 1.0.50
 */

$bonbon_template_args = get_query_var( 'bonbon_template_args' );
if ( is_array( $bonbon_template_args ) ) {
	$bonbon_columns    = empty( $bonbon_template_args['columns'] ) ? 2 : max( 1, $bonbon_template_args['columns'] );
	$bonbon_blog_style = array( $bonbon_template_args['type'], $bonbon_columns );
} else {
	$bonbon_template_args = array();
	$bonbon_blog_style = explode( '_', bonbon_get_theme_option( 'blog_style' ) );
	$bonbon_columns    = empty( $bonbon_blog_style[1] ) ? 2 : max( 1, $bonbon_blog_style[1] );
}
$bonbon_blog_id       = bonbon_get_custom_blog_id( join( '_', $bonbon_blog_style ) );
$bonbon_blog_style[0] = str_replace( 'blog-custom-', '', $bonbon_blog_style[0] );
$bonbon_expanded      = ! bonbon_sidebar_present() && bonbon_get_theme_option( 'expand_content' ) == 'expand';
$bonbon_components    = ! empty( $bonbon_template_args['meta_parts'] )
							? ( is_array( $bonbon_template_args['meta_parts'] )
								? join( ',', $bonbon_template_args['meta_parts'] )
								: $bonbon_template_args['meta_parts']
								)
							: bonbon_array_get_keys_by_value( bonbon_get_theme_option( 'meta_parts' ) );
$bonbon_post_format   = get_post_format();
$bonbon_post_format   = empty( $bonbon_post_format ) ? 'standard' : str_replace( 'post-format-', '', $bonbon_post_format );

$bonbon_blog_meta     = bonbon_get_custom_layout_meta( $bonbon_blog_id );
$bonbon_custom_style  = ! empty( $bonbon_blog_meta['scripts_required'] ) ? $bonbon_blog_meta['scripts_required'] : 'none';

if ( ! empty( $bonbon_template_args['slider'] ) || $bonbon_columns > 1 || ! bonbon_is_off( $bonbon_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $bonbon_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( bonbon_is_off( $bonbon_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $bonbon_custom_style ) ) . "-1_{$bonbon_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $bonbon_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $bonbon_columns )
					. ' post_layout_' . esc_attr( $bonbon_blog_style[0] )
					. ' post_layout_' . esc_attr( $bonbon_blog_style[0] ) . '_' . esc_attr( $bonbon_columns )
					. ( ! bonbon_is_off( $bonbon_custom_style )
						? ' post_layout_' . esc_attr( $bonbon_custom_style )
							. ' post_layout_' . esc_attr( $bonbon_custom_style ) . '_' . esc_attr( $bonbon_columns )
						: ''
						)
		);
	bonbon_add_blog_animation( $bonbon_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'bonbon_action_show_layout', $bonbon_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $bonbon_template_args['slider'] ) || $bonbon_columns > 1 || ! bonbon_is_off( $bonbon_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
