<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package BONBON
 * @since BONBON 1.0
 */

$bonbon_template_args = get_query_var( 'bonbon_template_args' );
$bonbon_columns = 1;
if ( is_array( $bonbon_template_args ) ) {
	$bonbon_columns    = empty( $bonbon_template_args['columns'] ) ? 1 : max( 1, $bonbon_template_args['columns'] );
	$bonbon_blog_style = array( $bonbon_template_args['type'], $bonbon_columns );
	if ( ! empty( $bonbon_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $bonbon_columns > 1 ) {
	    $bonbon_columns_class = bonbon_get_column_class( 1, $bonbon_columns, ! empty( $bonbon_template_args['columns_tablet']) ? $bonbon_template_args['columns_tablet'] : '', ! empty($bonbon_template_args['columns_mobile']) ? $bonbon_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $bonbon_columns_class ); ?>">
		<?php
	}
} else {
	$bonbon_template_args = array();
}
$bonbon_expanded    = ! bonbon_sidebar_present() && bonbon_get_theme_option( 'expand_content' ) == 'expand';
$bonbon_post_format = get_post_format();
$bonbon_post_format = empty( $bonbon_post_format ) ? 'standard' : str_replace( 'post-format-', '', $bonbon_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $bonbon_post_format ) );
	bonbon_add_blog_animation( $bonbon_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$bonbon_hover      = ! empty( $bonbon_template_args['hover'] ) && ! bonbon_is_inherit( $bonbon_template_args['hover'] )
							? $bonbon_template_args['hover']
							: bonbon_get_theme_option( 'image_hover' );
	$bonbon_components = ! empty( $bonbon_template_args['meta_parts'] )
							? ( is_array( $bonbon_template_args['meta_parts'] )
								? $bonbon_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $bonbon_template_args['meta_parts'] ) )
								)
							: bonbon_array_get_keys_by_value( bonbon_get_theme_option( 'meta_parts' ) );
	bonbon_show_post_featured( apply_filters( 'bonbon_filter_args_featured',
		array(
			'no_links'   => ! empty( $bonbon_template_args['no_links'] ),
			'hover'      => $bonbon_hover,
			'meta_parts' => $bonbon_components,
			'thumb_size' => ! empty( $bonbon_template_args['thumb_size'] )
							? $bonbon_template_args['thumb_size']
							: bonbon_get_thumb_size( strpos( bonbon_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $bonbon_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$bonbon_template_args
	) );

	// Title and post meta
	$bonbon_show_title = get_the_title() != '';
	$bonbon_show_meta  = count( $bonbon_components ) > 0 && ! in_array( $bonbon_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $bonbon_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'bonbon_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'bonbon_action_before_post_title' );
				if ( empty( $bonbon_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'bonbon_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'bonbon_filter_show_blog_excerpt', empty( $bonbon_template_args['hide_excerpt'] ) && bonbon_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'bonbon_filter_show_blog_meta', $bonbon_show_meta, $bonbon_components, 'excerpt' ) ) {
				if ( count( $bonbon_components ) > 0 ) {
					do_action( 'bonbon_action_before_post_meta' );
					bonbon_show_post_meta(
						apply_filters(
							'bonbon_filter_post_meta_args', array(
								'components' => join( ',', $bonbon_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'bonbon_action_after_post_meta' );
				}
			}

			if ( bonbon_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'bonbon_action_before_full_post_content' );
					the_content( '' );
					do_action( 'bonbon_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'bonbon' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'bonbon' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				bonbon_show_post_content( $bonbon_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'bonbon_filter_show_blog_readmore',  ! isset( $bonbon_template_args['more_button'] ) || ! empty( $bonbon_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $bonbon_template_args['no_links'] ) ) {
					do_action( 'bonbon_action_before_post_readmore' );
					if ( bonbon_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						bonbon_show_post_more_link( $bonbon_template_args, '<p>', '</p>' );
					} else {
						bonbon_show_post_comments_link( $bonbon_template_args, '<p>', '</p>' );
					}
					do_action( 'bonbon_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $bonbon_template_args ) ) {
	if ( ! empty( $bonbon_template_args['slider'] ) || $bonbon_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
