<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package BONBON
 * @since BONBON 1.0
 */

$bonbon_template_args = get_query_var( 'bonbon_template_args' );
if ( is_array( $bonbon_template_args ) ) {
	$bonbon_columns    = empty( $bonbon_template_args['columns'] ) ? 2 : max( 1, $bonbon_template_args['columns'] );
	$bonbon_blog_style = array( $bonbon_template_args['type'], $bonbon_columns );
    $bonbon_columns_class = bonbon_get_column_class( 1, $bonbon_columns, ! empty( $bonbon_template_args['columns_tablet']) ? $bonbon_template_args['columns_tablet'] : '', ! empty($bonbon_template_args['columns_mobile']) ? $bonbon_template_args['columns_mobile'] : '' );
} else {
	$bonbon_template_args = array();
	$bonbon_blog_style = explode( '_', bonbon_get_theme_option( 'blog_style' ) );
	$bonbon_columns    = empty( $bonbon_blog_style[1] ) ? 2 : max( 1, $bonbon_blog_style[1] );
    $bonbon_columns_class = bonbon_get_column_class( 1, $bonbon_columns );
}

$bonbon_post_format = get_post_format();
$bonbon_post_format = empty( $bonbon_post_format ) ? 'standard' : str_replace( 'post-format-', '', $bonbon_post_format );

?><div class="
<?php
if ( ! empty( $bonbon_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( bonbon_is_blog_style_use_masonry( $bonbon_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $bonbon_columns ) : esc_attr( $bonbon_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $bonbon_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $bonbon_columns )
		. ( 'portfolio' != $bonbon_blog_style[0] ? ' ' . esc_attr( $bonbon_blog_style[0] )  . '_' . esc_attr( $bonbon_columns ) : '' )
	);
	bonbon_add_blog_animation( $bonbon_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$bonbon_hover   = ! empty( $bonbon_template_args['hover'] ) && ! bonbon_is_inherit( $bonbon_template_args['hover'] )
								? $bonbon_template_args['hover']
								: bonbon_get_theme_option( 'image_hover' );

	if ( 'dots' == $bonbon_hover ) {
		$bonbon_post_link = empty( $bonbon_template_args['no_links'] )
								? ( ! empty( $bonbon_template_args['link'] )
									? $bonbon_template_args['link']
									: get_permalink()
									)
								: '';
		$bonbon_target    = ! empty( $bonbon_post_link ) && false === strpos( $bonbon_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$bonbon_components = ! empty( $bonbon_template_args['meta_parts'] )
							? ( is_array( $bonbon_template_args['meta_parts'] )
								? $bonbon_template_args['meta_parts']
								: explode( ',', $bonbon_template_args['meta_parts'] )
								)
							: bonbon_array_get_keys_by_value( bonbon_get_theme_option( 'meta_parts' ) );

	// Featured image
	bonbon_show_post_featured( apply_filters( 'bonbon_filter_args_featured',
        array(
			'hover'         => $bonbon_hover,
			'no_links'      => ! empty( $bonbon_template_args['no_links'] ),
			'thumb_size'    => ! empty( $bonbon_template_args['thumb_size'] )
								? $bonbon_template_args['thumb_size']
								: bonbon_get_thumb_size(
									bonbon_is_blog_style_use_masonry( $bonbon_blog_style[0] )
										? (	strpos( bonbon_get_theme_option( 'body_style' ), 'full' ) !== false || $bonbon_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( bonbon_get_theme_option( 'body_style' ), 'full' ) !== false || $bonbon_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => bonbon_is_blog_style_use_masonry( $bonbon_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $bonbon_components,
			'class'         => 'dots' == $bonbon_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $bonbon_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $bonbon_post_link )
												? '<a href="' . esc_url( $bonbon_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $bonbon_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $bonbon_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $bonbon_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!