<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package BONBON
 * @since BONBON 1.0
 */

$bonbon_columns     = max( 1, min( 3, count( get_option( 'sticky_posts' ) ) ) );
$bonbon_post_format = get_post_format();
$bonbon_post_format = empty( $bonbon_post_format ) ? 'standard' : str_replace( 'post-format-', '', $bonbon_post_format );

?><div class="column-1_<?php echo esc_attr( $bonbon_columns ); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class( 'post_item post_layout_sticky post_format_' . esc_attr( $bonbon_post_format ) );
	bonbon_add_blog_animation( $bonbon_template_args );
	?>
>

	<?php
	if ( is_sticky() && is_home() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	bonbon_show_post_featured(
		array(
			'thumb_size' => bonbon_get_thumb_size( 1 == $bonbon_columns ? 'big' : ( 2 == $bonbon_columns ? 'med' : 'avatar' ) ),
		)
	);

	if ( ! in_array( $bonbon_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h5 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			bonbon_show_post_meta( apply_filters( 'bonbon_filter_post_meta_args', array(), 'sticky', $bonbon_columns ) );
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div><?php

// div.column-1_X is a inline-block and new lines and spaces after it are forbidden
