<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package BONBON
 * @since BONBON 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$bonbon_copyright_scheme = bonbon_get_theme_option( 'copyright_scheme' );
if ( ! empty( $bonbon_copyright_scheme ) && ! bonbon_is_inherit( $bonbon_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $bonbon_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$bonbon_copyright = bonbon_get_theme_option( 'copyright' );
			if ( ! empty( $bonbon_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$bonbon_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $bonbon_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$bonbon_copyright = bonbon_prepare_macros( $bonbon_copyright );
				// Display copyright
				echo wp_kses( nl2br( $bonbon_copyright ), 'bonbon_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
