<?php
/**
 * The template to display default site footer
 *
 * @package BONBON
 * @since BONBON 1.0.10
 */

$bonbon_footer_id = bonbon_get_custom_footer_id();
$bonbon_footer_meta = get_post_meta( $bonbon_footer_id, 'trx_addons_options', true );
if ( ! empty( $bonbon_footer_meta['margin'] ) ) {
	bonbon_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( bonbon_prepare_css_value( $bonbon_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $bonbon_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $bonbon_footer_id ) ) ); ?>
						<?php
						$bonbon_footer_scheme = bonbon_get_theme_option( 'footer_scheme' );
						if ( ! empty( $bonbon_footer_scheme ) && ! bonbon_is_inherit( $bonbon_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $bonbon_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'bonbon_action_show_layout', $bonbon_footer_id );
	?>
</footer><!-- /.footer_wrap -->
