<?php
/**
 * The template to display the site logo in the footer
 *
 * @package BONBON
 * @since BONBON 1.0.10
 */

// Logo
if ( bonbon_is_on( bonbon_get_theme_option( 'logo_in_footer' ) ) ) {
	$bonbon_logo_image = bonbon_get_logo_image( 'footer' );
	$bonbon_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $bonbon_logo_image['logo'] ) || ! empty( $bonbon_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $bonbon_logo_image['logo'] ) ) {
					$bonbon_attr = bonbon_getimagesize( $bonbon_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $bonbon_logo_image['logo'] ) . '"'
								. ( ! empty( $bonbon_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $bonbon_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'bonbon' ) . '"'
								. ( ! empty( $bonbon_attr[3] ) ? ' ' . wp_kses_data( $bonbon_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $bonbon_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $bonbon_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
