<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package BONBON
 * @since BONBON 1.0.10
 */

// Footer sidebar
$bonbon_footer_name    = bonbon_get_theme_option( 'footer_widgets' );
$bonbon_footer_present = ! bonbon_is_off( $bonbon_footer_name ) && is_active_sidebar( $bonbon_footer_name );
if ( $bonbon_footer_present ) {
	bonbon_storage_set( 'current_sidebar', 'footer' );
	$bonbon_footer_wide = bonbon_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $bonbon_footer_name ) ) {
		dynamic_sidebar( $bonbon_footer_name );
	}
	$bonbon_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $bonbon_out ) ) {
		$bonbon_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $bonbon_out );
		$bonbon_need_columns = true;   //or check: strpos($bonbon_out, 'columns_wrap')===false;
		if ( $bonbon_need_columns ) {
			$bonbon_columns = max( 0, (int) bonbon_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $bonbon_columns ) {
				$bonbon_columns = min( 4, max( 1, bonbon_tags_count( $bonbon_out, 'aside' ) ) );
			}
			if ( $bonbon_columns > 1 ) {
				$bonbon_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $bonbon_columns ) . ' widget', $bonbon_out );
			} else {
				$bonbon_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $bonbon_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'bonbon_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $bonbon_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $bonbon_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'bonbon_action_before_sidebar', 'footer' );
				bonbon_show_layout( $bonbon_out );
				do_action( 'bonbon_action_after_sidebar', 'footer' );
				if ( $bonbon_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $bonbon_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'bonbon_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
