<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package BONBON
 * @since BONBON 1.0.06
 */

$bonbon_header_css   = '';
$bonbon_header_image = get_header_image();
$bonbon_header_video = bonbon_get_header_video();
if ( ! empty( $bonbon_header_image ) && bonbon_trx_addons_featured_image_override( is_singular() || bonbon_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$bonbon_header_image = bonbon_get_current_mode_image( $bonbon_header_image );
}

$bonbon_header_id = bonbon_get_custom_header_id();
$bonbon_header_meta = get_post_meta( $bonbon_header_id, 'trx_addons_options', true );
if ( ! empty( $bonbon_header_meta['margin'] ) ) {
	bonbon_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( bonbon_prepare_css_value( $bonbon_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $bonbon_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $bonbon_header_id ) ) ); ?>
				<?php
				echo ! empty( $bonbon_header_image ) || ! empty( $bonbon_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $bonbon_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $bonbon_header_image ) {
					echo ' ' . esc_attr( bonbon_add_inline_css_class( 'background-image: url(' . esc_url( $bonbon_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( bonbon_is_on( bonbon_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight bonbon-full-height';
				}
				$bonbon_header_scheme = bonbon_get_theme_option( 'header_scheme' );
				if ( ! empty( $bonbon_header_scheme ) && ! bonbon_is_inherit( $bonbon_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $bonbon_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $bonbon_header_video ) ) {
		get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'bonbon_action_show_layout', $bonbon_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
