<?php
/**
 * The template to display default site header
 *
 * @package BONBON
 * @since BONBON 1.0
 */

$bonbon_header_css   = '';
$bonbon_header_image = get_header_image();
$bonbon_header_video = bonbon_get_header_video();
if ( ! empty( $bonbon_header_image ) && bonbon_trx_addons_featured_image_override( is_singular() || bonbon_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$bonbon_header_image = bonbon_get_current_mode_image( $bonbon_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $bonbon_header_image ) || ! empty( $bonbon_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $bonbon_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $bonbon_header_image ) {
		echo ' ' . esc_attr( bonbon_add_inline_css_class( 'background-image: url(' . esc_url( $bonbon_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( bonbon_is_on( bonbon_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight bonbon-full-height';
	}
	$bonbon_header_scheme = bonbon_get_theme_option( 'header_scheme' );
	if ( ! empty( $bonbon_header_scheme ) && ! bonbon_is_inherit( $bonbon_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $bonbon_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $bonbon_header_video ) ) {
		get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( bonbon_is_on( bonbon_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'bonbon_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
