<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package BONBON
 * @since BONBON 1.0
 */

$bonbon_args = get_query_var( 'bonbon_logo_args' );

// Site logo
$bonbon_logo_type   = isset( $bonbon_args['type'] ) ? $bonbon_args['type'] : '';
$bonbon_logo_image  = bonbon_get_logo_image( $bonbon_logo_type );
$bonbon_logo_text   = bonbon_is_on( bonbon_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$bonbon_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $bonbon_logo_image['logo'] ) || ! empty( $bonbon_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $bonbon_logo_image['logo'] ) ) {
			if ( empty( $bonbon_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($bonbon_logo_image['logo']) && (int) $bonbon_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$bonbon_attr = bonbon_getimagesize( $bonbon_logo_image['logo'] );
				echo '<img src="' . esc_url( $bonbon_logo_image['logo'] ) . '"'
						. ( ! empty( $bonbon_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $bonbon_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $bonbon_logo_text ) . '"'
						. ( ! empty( $bonbon_attr[3] ) ? ' ' . wp_kses_data( $bonbon_attr[3] ) : '' )
						. '>';
			}
		} else {
			bonbon_show_layout( bonbon_prepare_macros( $bonbon_logo_text ), '<span class="logo_text">', '</span>' );
			bonbon_show_layout( bonbon_prepare_macros( $bonbon_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
