<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package BONBON
 * @since BONBON 1.0
 */

// Page (category, tag, archive, author) title

if ( bonbon_need_page_title() ) {
	bonbon_sc_layouts_showed( 'title', true );
	bonbon_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								bonbon_show_post_meta(
									apply_filters(
										'bonbon_filter_post_meta_args', array(
											'components' => join( ',', bonbon_array_get_keys_by_value( bonbon_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', bonbon_array_get_keys_by_value( bonbon_get_theme_option( 'counters' ) ) ),
											'seo'        => bonbon_is_on( bonbon_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$bonbon_blog_title           = bonbon_get_blog_title();
							$bonbon_blog_title_text      = '';
							$bonbon_blog_title_class     = '';
							$bonbon_blog_title_link      = '';
							$bonbon_blog_title_link_text = '';
							if ( is_array( $bonbon_blog_title ) ) {
								$bonbon_blog_title_text      = $bonbon_blog_title['text'];
								$bonbon_blog_title_class     = ! empty( $bonbon_blog_title['class'] ) ? ' ' . $bonbon_blog_title['class'] : '';
								$bonbon_blog_title_link      = ! empty( $bonbon_blog_title['link'] ) ? $bonbon_blog_title['link'] : '';
								$bonbon_blog_title_link_text = ! empty( $bonbon_blog_title['link_text'] ) ? $bonbon_blog_title['link_text'] : '';
							} else {
								$bonbon_blog_title_text = $bonbon_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $bonbon_blog_title_class ); ?>">
								<?php
								$bonbon_top_icon = bonbon_get_term_image_small();
								if ( ! empty( $bonbon_top_icon ) ) {
									$bonbon_attr = bonbon_getimagesize( $bonbon_top_icon );
									?>
									<img src="<?php echo esc_url( $bonbon_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'bonbon' ); ?>"
										<?php
										if ( ! empty( $bonbon_attr[3] ) ) {
											bonbon_show_layout( $bonbon_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $bonbon_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $bonbon_blog_title_link ) && ! empty( $bonbon_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $bonbon_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $bonbon_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'bonbon_action_breadcrumbs' );
						$bonbon_breadcrumbs = ob_get_contents();
						ob_end_clean();
						bonbon_show_layout( $bonbon_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
