<?php
/**
 * The template to display the widgets area in the header
 *
 * @package BONBON
 * @since BONBON 1.0
 */

// Header sidebar
$bonbon_header_name    = bonbon_get_theme_option( 'header_widgets' );
$bonbon_header_present = ! bonbon_is_off( $bonbon_header_name ) && is_active_sidebar( $bonbon_header_name );
if ( $bonbon_header_present ) {
	bonbon_storage_set( 'current_sidebar', 'header' );
	$bonbon_header_wide = bonbon_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $bonbon_header_name ) ) {
		dynamic_sidebar( $bonbon_header_name );
	}
	$bonbon_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $bonbon_widgets_output ) ) {
		$bonbon_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $bonbon_widgets_output );
		$bonbon_need_columns   = strpos( $bonbon_widgets_output, 'columns_wrap' ) === false;
		if ( $bonbon_need_columns ) {
			$bonbon_columns = max( 0, (int) bonbon_get_theme_option( 'header_columns' ) );
			if ( 0 == $bonbon_columns ) {
				$bonbon_columns = min( 6, max( 1, bonbon_tags_count( $bonbon_widgets_output, 'aside' ) ) );
			}
			if ( $bonbon_columns > 1 ) {
				$bonbon_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $bonbon_columns ) . ' widget', $bonbon_widgets_output );
			} else {
				$bonbon_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $bonbon_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'bonbon_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $bonbon_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $bonbon_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'bonbon_action_before_sidebar', 'header' );
				bonbon_show_layout( $bonbon_widgets_output );
				do_action( 'bonbon_action_after_sidebar', 'header' );
				if ( $bonbon_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $bonbon_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'bonbon_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
