<?php
/**
 * The template 'Style 1' to displaying related posts
 *
 * @package BONBON
 * @since BONBON 1.0
 */

$bonbon_link        = get_permalink();
$bonbon_post_format = get_post_format();
$bonbon_post_format = empty( $bonbon_post_format ) ? 'standard' : str_replace( 'post-format-', '', $bonbon_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $bonbon_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	bonbon_show_post_featured(
		array(
			'thumb_size'    => apply_filters( 'bonbon_filter_related_thumb_size', bonbon_get_thumb_size( (int) bonbon_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
			'post_info'     => '<div class="post_header entry-header">'
									. '<div class="post_categories">' . wp_kses( bonbon_get_post_categories( '' ), 'bonbon_kses_content' ) . '</div>'
									. '<h6 class="post_title entry-title"><a href="' . esc_url( $bonbon_link ) . '">'
										. wp_kses_data( '' == get_the_title() ? esc_html__( '- No title -', 'bonbon' ) : get_the_title() )
									. '</a></h6>'
									. ( in_array( get_post_type(), array( 'post', 'attachment' ) )
											? '<div class="post_meta"><a href="' . esc_url( $bonbon_link ) . '" class="post_meta_item post_date">' . wp_kses_data( bonbon_get_date() ) . '</a></div>'
											: '' )
								. '</div>',
		)
	);
	?>
</div>
