<?php
/**
 * The template to display Admin notices
 *
 * @package BONBON
 * @since BONBON 1.0.64
 */

$bonbon_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$bonbon_skins_args = get_query_var( 'bonbon_skins_notice_args' );
?>
<div class="bonbon_admin_notice bonbon_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$bonbon_theme_img = bonbon_get_file_url( 'screenshot.jpg' );
	if ( '' != $bonbon_theme_img ) {
		?>
		<div class="bonbon_notice_image"><img src="<?php echo esc_url( $bonbon_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'bonbon' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="bonbon_notice_title">
		<?php esc_html_e( 'New skins available', 'bonbon' ); ?>
	</h3>
	<?php

	// Description
	$bonbon_total      = $bonbon_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$bonbon_skins_msg  = $bonbon_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $bonbon_total, 'bonbon' ), $bonbon_total ) . '</strong>'
							: '';
	$bonbon_total      = $bonbon_skins_args['free'];
	$bonbon_skins_msg .= $bonbon_total > 0
							? ( ! empty( $bonbon_skins_msg ) ? ' ' . esc_html__( 'and', 'bonbon' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $bonbon_total, 'bonbon' ), $bonbon_total ) . '</strong>'
							: '';
	$bonbon_total      = $bonbon_skins_args['pay'];
	$bonbon_skins_msg .= $bonbon_skins_args['pay'] > 0
							? ( ! empty( $bonbon_skins_msg ) ? ' ' . esc_html__( 'and', 'bonbon' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $bonbon_total, 'bonbon' ), $bonbon_total ) . '</strong>'
							: '';
	?>
	<div class="bonbon_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'bonbon' ), $bonbon_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="bonbon_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $bonbon_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'bonbon' );
			?>
		</a>
	</div>
</div>
